/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.statistics;

import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.VWSIMAnimatorStep;
import filenet.sim.toolkit.viewer.statistics.VWSIMStatisticsTableCellRenderer;
import filenet.sim.toolkit.viewer.statistics.VWSIMStepStatPanel;
import filenet.sim.toolkit.viewer.statistics.VWSIMStepStatTableModel;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableSorter;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class VWSIMStepStatTable
extends VWTable
implements MouseListener {
    protected Frame m_parentFrame = null;
    private VWSIMStepStatPanel m_stepStatPanel = null;
    private boolean m_initialized = false;
    protected VWSIMStepStatTableModel m_tableModel = null;
    private VWTableSorter m_tableSorter = null;
    private VWSIMStatisticsTableCellRenderer m_renderer = null;
    protected TableColumnModel m_columnModel = null;
    private boolean m_tabSelected = false;

    public static String _get_FILE_DATE() {
        return "$Date:   14 Feb 2005 14:51:28  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.3  $";
    }

    public VWSIMStepStatTable(Frame parentFrame, VWSIMStepStatTableModel tableModel) {
        this(parentFrame, null, tableModel);
    }

    public VWSIMStepStatTable(Frame parentFrame, VWSIMStepStatPanel stepStatPanel, VWSIMStepStatTableModel tableModel) {
        super(tableModel);
        this.m_parentFrame = parentFrame;
        this.m_stepStatPanel = stepStatPanel;
        this.m_tableModel = tableModel;
        this.init();
        this.addMouseListener(this);
    }

    public VWSIMStepStatTable(Frame parentFrame, VWTableSorter tableSorter) {
        this(parentFrame, null, tableSorter);
    }

    public VWSIMStepStatTable(Frame parentFrame, VWSIMStepStatPanel stepStatPanel, VWTableSorter tableSorter) {
        super(tableSorter);
        this.m_parentFrame = parentFrame;
        this.m_stepStatPanel = stepStatPanel;
        TableModel tm = null;
        this.m_tableSorter = tableSorter;
        tm = tableSorter.getModel();
        if (tm != null && tm instanceof VWSIMStepStatTableModel) {
            this.m_tableModel = (VWSIMStepStatTableModel)tm;
        }
        this.init();
    }

    public void addNotify() {
        super.addNotify();
        this.init();
    }

    private void init() {
        this.m_columnModel = this.getColumnModel();
        this.m_renderer = new VWSIMStatisticsTableCellRenderer();
        this.setShowGrid(false);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fm = this.getFontMetrics(font);
            for (int i = 0; i <= 16; ++i) {
                this.sizeTableColumn(fm, i);
            }
        }
        this.m_initialized = true;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    VWSIMAnimatorDataModel getDataModel() {
        if (this.m_tableModel != null) {
            return this.m_tableModel.getDataModel();
        }
        return null;
    }

    void tabSelected(boolean selected) {
        this.m_tabSelected = selected;
    }

    private void sizeTableColumn(FontMetrics fm, int col) {
        TableColumn column = this.m_columnModel.getColumn(col);
        column.setCellRenderer(this.m_renderer);
        int width = this.getMaxStringWidth(fm, null, col);
        if (width != 0) {
            column.setPreferredWidth(width += 10);
        }
    }

    private int getMaxStringWidth(FontMetrics fm, String header, int col) {
        if (fm == null) {
            return 0;
        }
        int width = 0;
        if (header != null) {
            width = fm.stringWidth(header);
        }
        if (this.m_tableModel != null) {
            String str = null;
            Icon icon = null;
            int gap = 0;
            int w = 0;
            width = fm.stringWidth(this.m_tableModel.getColumnName(col));
            for (int i = 0; i < this.m_tableModel.getRowCount(); ++i) {
                Object obj = this.m_tableModel.getValueAt(i, col);
                if (obj == null) continue;
                if (obj instanceof String) {
                    str = (String)obj;
                } else if (obj instanceof JLabel) {
                    str = ((JLabel)obj).getText();
                    icon = ((JLabel)obj).getIcon();
                    gap = ((JLabel)obj).getIconTextGap();
                }
                if (str != null && str.length() > 0) {
                    w = fm.stringWidth(str);
                }
                if (icon != null) {
                    w += icon.getIconWidth();
                    w += gap;
                }
                if (w <= width) continue;
                width = w;
            }
        }
        return width;
    }

    private int getStringWidth(FontMetrics fm, String str) {
        if (fm == null) {
            return 0;
        }
        int width = 0;
        if (str != null) {
            width = fm.stringWidth(str);
        }
        return width;
    }

    public void mouseClicked(MouseEvent evt) {
        Object source = evt.getSource();
        if (source != this) {
            return;
        }
        Point point = evt.getPoint();
        int row = this.rowAtPoint(point);
        int col = this.columnAtPoint(point);
        if (this.m_tableModel != null && evt.getClickCount() == 2) {
            this.notifyStepSelected(row, col);
            this.m_tableModel.cellClicked(row, col);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void notifyStepSelected(int row, int col) {
        Object obj;
        if (this.m_stepStatPanel != null && col != 0 && col != 1 && this.m_tableModel != null && (obj = this.m_tableModel.getValueAt(row)) != null && obj instanceof VWSIMAnimatorStep) {
            this.m_stepStatPanel.notifyStepSelected((VWSIMAnimatorStep)obj);
        }
    }

    void releaseResources() {
        this.m_parentFrame = null;
        this.m_stepStatPanel = null;
        this.m_tableSorter = null;
        if (this.m_tableModel != null && this.m_columnModel != null) {
            int n = this.m_tableModel.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.m_columnModel.getColumn(i).setCellRenderer(null);
            }
        }
        this.m_tableModel = null;
        this.m_renderer = null;
        this.m_columnModel = null;
        this.removeAll();
    }
}

